# Assembly Guide: Terracore Mk1 Rapid Synthesis System

## Tools Needed
- Screwdriver set
- Wire cutters/strippers
- Drill with assorted bits
- Utility knife
- Soldering iron (helpful, not essential)
- Multimeter

## Step 1: Build the Instant Environment Chamber

### Chamber Preparation
1. Select insulated cooler or build insulated box (12"x12"x18" minimum)
2. Line interior with food-safe aluminum foil for heat reflection
3. Cut access holes for:
   - Power cables (back)
   - Fogger output (side)
   - Viewing window (front)

### Heating System Installation
1. Mount 150W cartridge heater to chamber wall
2. Place thermal mass (brick/stone) near heater
3. Install temperature sensor in chamber center
4. Connect heater to thermostat, then to power supply

### Humidity System
1. Mount ultrasonic fogger outside chamber
2. Route fog tube through side hole into chamber
3. Position fog output above where bio-fabric will sit
4. Connect to power supply

## Step 2: Assemble Deposition System

### Pump and Valve Setup
1. Mount 12V diaphragm pump to chamber exterior
2. Install solenoid valve after pump output
3. Connect tubing: reservoir → pump → valve → spray nozzle

### Nozzle Installation
1. Mount spray nozzle inside chamber ceiling
2. Position to evenly cover bio-fabric area
3. Ensure nozzle isn't blocked by other components

### Reservoir Preparation
1. Use pressure-rated plastic bottle
2. Drill hole for tubing connection
3. Create nutrient mixing measurements on side

## Step 3: Electrical Integration

### Power Distribution
1. Connect 12V power supply to central terminal
2. Wire pump, solenoid, and fogger to switch/timer
3. Install emergency stop switch for safety
4. Use fuse or circuit breaker on main power line

### Control System
1. Mount timer/switch board externally
2. Label all controls clearly:
   - Chamber Heat
   - Fogger
   - Synthesis Start
   - Emergency Stop

## Step 4: Prepare Bio-Fabric

### Initial Cultivation
1. Inoculate liquid culture with oyster mushroom spores
2. Transfer to pasteurized cardboard substrate
3. Allow full colonization (1-2 weeks)
4. Store in airtight container for hibernation

### Nutrient Trigger Solution
- 1 cup warm water
- 2 tablespoons malt extract
- 1 teaspoon nutritional yeast
- Mix thoroughly before each use

## Operation Procedure

### Daily Preparation (2 minutes)
1. Turn on chamber heat 30 minutes before use
2. Start fogger to pre-humidify chamber
3. Mix fresh nutrient solution in reservoir

### Synthesis Cycle (10 minutes)
1. Place bio-fabric in pre-heated chamber
2. Close and seal chamber door
3. Press "Synthesis Start" - triggers 60-second nutrient spray
4. Wait 8 minutes with chamber sealed
5. Open chamber and harvest

### Post-Synthesis (5 minutes)
1. Remove synthesized biomass
2. Clean chamber surfaces
3. Return bio-fabric to hibernation storage
4. Record results and observations

## Calibration Guide

### Temperature Calibration
- Target: 75-80°F (24-27°C)
- Adjust thermostat until stable
- Test recovery after door opening

### Humidity Calibration
- Target: 90-95% RH
- Adjust fogger run time
- Verify with hygrometer

### Deposition Calibration
- Target: Even coverage across entire surface
- Adjust nozzle position if needed
- Test with water first

## Troubleshooting

### No Synthesis
- Check nutrient solution freshness
- Verify bio-fabric viability
- Confirm temperature/humidity levels

### Poor Yield
- Increase nutrient concentration slightly
- Extend synthesis time to 15 minutes
- Check spray pattern coverage

### Equipment Issues
- Clean nozzle if clogged
- Check all electrical connections
- Verify pump pressure

## Maintenance Schedule

### After Each Use
- Clean chamber surfaces
- Rinse deposition system with clean water
- Check bio-fabric condition

### Weekly
- Deep clean entire system
- Sterilize bio-fabric containers
- Test all electrical components

### Monthly
- Replace any worn tubing
- Calibrate sensors
- Refresh bio-fabric stock

## Safety Notes
- Always use GFCI outlet or circuit breaker
- Keep electrical components away from water sources
- Wear gloves when handling biological materials
- Never leave system unattended during operation

This system brings space-age food technology to your backyard. Build it, use it, and join the food synthesis revolution.
